/*
 * Decompiled with CFR 0.152.
 */
package qouteall.q_misc_util.my_util;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Comparator;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2470;
import org.apache.commons.lang3.Validate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import qouteall.q_misc_util.my_util.DQuaternion;
import qouteall.q_misc_util.my_util.IntMatrix3;

public enum AARotation {
    SOUTH_ROT0(class_2350.field_11035, class_2350.field_11034),
    SOUTH_ROT90(class_2350.field_11035, class_2350.field_11036),
    SOUTH_ROT180(class_2350.field_11035, class_2350.field_11039),
    SOUTH_ROT270(class_2350.field_11035, class_2350.field_11033),
    NORTH_ROT0(class_2350.field_11043, class_2350.field_11039),
    NORTH_ROT90(class_2350.field_11043, class_2350.field_11036),
    NORTH_ROT180(class_2350.field_11043, class_2350.field_11034),
    NORTH_ROT270(class_2350.field_11043, class_2350.field_11033),
    EAST_ROT0(class_2350.field_11034, class_2350.field_11043),
    EAST_ROT90(class_2350.field_11034, class_2350.field_11036),
    EAST_ROT180(class_2350.field_11034, class_2350.field_11035),
    EAST_ROT270(class_2350.field_11034, class_2350.field_11033),
    WEST_ROT0(class_2350.field_11039, class_2350.field_11035),
    WEST_ROT90(class_2350.field_11039, class_2350.field_11036),
    WEST_ROT180(class_2350.field_11039, class_2350.field_11043),
    WEST_ROT270(class_2350.field_11039, class_2350.field_11033),
    UP_ROT0(class_2350.field_11036, class_2350.field_11043),
    UP_ROT90(class_2350.field_11036, class_2350.field_11039),
    UP_ROT180(class_2350.field_11036, class_2350.field_11035),
    UP_ROT270(class_2350.field_11036, class_2350.field_11034),
    DOWN_ROT0(class_2350.field_11033, class_2350.field_11035),
    DOWN_ROT90(class_2350.field_11033, class_2350.field_11039),
    DOWN_ROT180(class_2350.field_11033, class_2350.field_11043),
    DOWN_ROT270(class_2350.field_11033, class_2350.field_11034);

    public static final AARotation IDENTITY;
    public final class_2350 transformedX;
    public final class_2350 transformedY;
    public final class_2350 transformedZ;
    public final IntMatrix3 matrix;
    public final DQuaternion quaternion;
    private static final AARotation[][] multiplicationCache;
    private static final AARotation[] inverseCache;
    public static final ImmutableList<AARotation> rotationsSortedByAngle;

    private AARotation(class_2350 transformedZ, class_2350 transformedX) {
        this.transformedZ = transformedZ;
        this.transformedX = transformedX;
        this.transformedY = AARotation.dirCrossProduct(transformedZ, transformedX);
        this.matrix = new IntMatrix3(this.transformedX.method_10163(), this.transformedY.method_10163(), this.transformedZ.method_10163());
        this.quaternion = this.matrix.toQuaternion();
    }

    public class_2338 transform(class_2382 vec) {
        return this.matrix.transform(vec);
    }

    public class_2350 transformDirection(class_2350 direction) {
        class_2338 transformedVec = this.transform(direction.method_10163());
        return class_2350.method_50026((int)transformedVec.method_10263(), (int)transformedVec.method_10264(), (int)transformedVec.method_10260());
    }

    @NotNull
    public static class_2350 dirCrossProduct(class_2350 a, class_2350 b) {
        Validate.isTrue((a.method_10166() != b.method_10166() ? 1 : 0) != 0);
        class_2350 result = class_2350.method_50026((int)(a.method_10164() * b.method_10165() - a.method_10165() * b.method_10164()), (int)(a.method_10165() * b.method_10148() - a.method_10148() * b.method_10165()), (int)(a.method_10148() * b.method_10164() - a.method_10164() * b.method_10148()));
        Validate.notNull((Object)result);
        return result;
    }

    public static class_2350 rotateDir90DegreesAlong(class_2350 direction, class_2350 axis) {
        if (direction.method_10166() == axis.method_10166()) {
            return direction;
        }
        return AARotation.dirCrossProduct(axis, direction);
    }

    public AARotation multiply(AARotation other) {
        return multiplicationCache[this.ordinal()][other.ordinal()];
    }

    private AARotation rawMultiply(AARotation other) {
        return AARotation.getAARotationFromZX(this.transformDirection(other.transformedZ), this.transformDirection(other.transformedX));
    }

    public static AARotation getAARotationFromZX(class_2350 transformedZ, class_2350 transformedX) {
        for (AARotation value : AARotation.values()) {
            if (value.transformedZ != transformedZ || value.transformedX != transformedX) continue;
            return value;
        }
        throw new IllegalArgumentException();
    }

    public static AARotation getAARotationFromYZ(class_2350 transformedY, class_2350 transformedZ) {
        for (AARotation value : AARotation.values()) {
            if (value.transformedY != transformedY || value.transformedZ != transformedZ) continue;
            return value;
        }
        throw new IllegalArgumentException();
    }

    public static AARotation getAARotationFromXY(class_2350 transformedX, class_2350 transformedY) {
        for (AARotation value : AARotation.values()) {
            if (value.transformedX != transformedX || value.transformedY != transformedY) continue;
            return value;
        }
        throw new IllegalArgumentException();
    }

    public AARotation getInverse() {
        return inverseCache[this.ordinal()];
    }

    public static AARotation get90DegreesRotationAlong(class_2350 direction) {
        class_2350 defaultX = class_2350.field_11034;
        class_2350 defaultY = class_2350.field_11036;
        class_2350 newX = AARotation.rotateDir90DegreesAlong(defaultX, direction);
        class_2350 newY = AARotation.rotateDir90DegreesAlong(defaultY, direction);
        return AARotation.getAARotationFromXY(newX, newY);
    }

    @Nullable
    public class_2470 toVanillaRotation() {
        return switch (this.ordinal()) {
            case 0 -> class_2470.field_11467;
            case 8 -> class_2470.field_11465;
            case 4 -> class_2470.field_11464;
            case 12 -> class_2470.field_11463;
            default -> null;
        };
    }

    public static AARotation fromVanillaRotation(class_2470 vanillaRotation) {
        return switch (vanillaRotation) {
            default -> throw new IncompatibleClassChangeError();
            case class_2470.field_11467 -> SOUTH_ROT0;
            case class_2470.field_11463 -> WEST_ROT0;
            case class_2470.field_11464 -> NORTH_ROT0;
            case class_2470.field_11465 -> EAST_ROT0;
        };
    }

    static {
        IDENTITY = SOUTH_ROT0;
        multiplicationCache = new AARotation[24][24];
        for (AARotation a : AARotation.values()) {
            for (AARotation b2 : AARotation.values()) {
                AARotation.multiplicationCache[a.ordinal()][b2.ordinal()] = a.rawMultiply(b2);
            }
        }
        inverseCache = new AARotation[24];
        AARotation[] values = AARotation.values();
        for (int i = 0; i < values.length; ++i) {
            AARotation inverse;
            AARotation rot = values[i];
            AARotation.inverseCache[i] = inverse = Arrays.stream(AARotation.values()).filter(b -> rot.multiply((AARotation)((Object)b)) == IDENTITY).findFirst().orElseThrow();
        }
        AARotation[] array = Arrays.copyOf(AARotation.values(), 24);
        Arrays.sort(array, Comparator.comparingDouble(r -> r.quaternion.getRotatingAngleDegrees()));
        rotationsSortedByAngle = ImmutableList.copyOf((Object[])array);
    }
}

